void Manger_Wifi_load() {

      if (SPIFFS.begin()) {
          Serial.println("mounted file system");
          if (SPIFFS.exists("/config.json")) {
            //file exists, reading and loading
            Serial.println("reading config file");
            File configFile = SPIFFS.open("/config.json", "r");
            if (configFile) {
              Serial.println("opened config file");
              size_t size = configFile.size();
              // Allocate a buffer to store contents of the file.
              std::unique_ptr<char[]> buf(new char[size]);
      
              configFile.readBytes(buf.get(), size);
              DynamicJsonBuffer jsonBuffer;
              JsonObject& json = jsonBuffer.parseObject(buf.get());
              json.printTo(Serial);
              if (json.success()) {
                Serial.println("\nparsed json");
                   
                strcpy(UTC_Timezone, json["UTC_Timezone"]);
                strcpy(Time_S_W, json["Time_S_W"]);
                strcpy(GPS_NTP, json["GPS_NTP"]);
                strcpy(mqtt_on, json["mqtt_on"]);
                strcpy(mqtt_server, json["mqtt_server"]);
                strcpy(mqtt_port, json["mqtt_port"]);
                strcpy(mqtt_user, json["mqtt_user"]);          
                strcpy(mqtt_pass, json["mqtt_pass"]);
                strcpy(mqtt_root_topic, json["mqtt_root_topic"]);
                strcpy(mqtt_root_topic1, json["mqtt_root_topic1"]);
                strcpy(mqtt_root_topic2, json["mqtt_root_topic2"]);
                strcpy(mqtt_root_topic3, json["mqtt_root_topic3"]); 
                strcpy(mqtt_root_topic4, json["mqtt_root_topic4"]);
                strcpy(mqtt_root_topic5, json["mqtt_root_topic5"]); 
                strcpy(mqtt_api_key, json["mqtt_api_key"]);
                strcpy(web_pass, json["web_pass"]);          
                } else {
                Serial.println("failed to load json config");
              }
            }
          }
        } else {
          Serial.println("failed to mount file system");
        }
      
        WiFiManagerParameter custom_text4("<b>Time Zone</b><br><b>-11 - +12</b>");
        WiFiManagerParameter custom_UTC_Timezone("Time Zone", "Time Zone", UTC_Timezone, 2);
        WiFiManagerParameter custom_text5("<b>Summertime / Wintertime</b><br><b>1 or 0</b>");
        WiFiManagerParameter custom_Time_S_W("Summertime / Wintertime", "Summertime / Wintertime", Time_S_W, 2);
        WiFiManagerParameter custom_text3("<b>NTP Time</b><br><b>1 or 0</b>");
        WiFiManagerParameter custom_GPS_NTP("GPS or NTP", "GPS or NTP", GPS_NTP, 2);     
        WiFiManagerParameter custom_text2("<b>MQTT Server</b>");
        WiFiManagerParameter custom_mqtt_on("on=1/off=0", "on=1/off=0", mqtt_on, 2); 
        WiFiManagerParameter custom_mqtt_server("server", "mqtt Server IP", mqtt_server, 16);
        WiFiManagerParameter custom_mqtt_port("port", "mqtt port", mqtt_port, 6);
        WiFiManagerParameter custom_mqtt_user("user", "mqtt user", mqtt_user, 20);
        WiFiManagerParameter custom_mqtt_pass("pass", "mqtt pass", mqtt_pass, 20);
        WiFiManagerParameter custom_mqtt_root_topic("out topic", "mqtt root topic", mqtt_root_topic, 40);
        WiFiManagerParameter custom_mqtt_root_topic1("out topic1", "mqtt root topic1", mqtt_root_topic1, 40);
        WiFiManagerParameter custom_mqtt_root_topic2("in topic2", "mqtt root topic2", mqtt_root_topic2, 40);
        WiFiManagerParameter custom_mqtt_root_topic3("in topic3", "mqtt root topic3", mqtt_root_topic3, 40);
        WiFiManagerParameter custom_mqtt_root_topic4("in topic4", "mqtt root topic4", mqtt_root_topic4, 40);
        WiFiManagerParameter custom_mqtt_root_topic5("out topic5", "mqtt root topic5", mqtt_root_topic5, 40);
        WiFiManagerParameter custom_mqtt_api_key("api_key", "mqtt api_key", mqtt_api_key, 40);
        WiFiManagerParameter custom_web_pass("Webpass", "web_pass", web_pass, 20);
      
        WiFiManager wifiManager;  
        wifiManager.setSaveConfigCallback(saveConfigCallback);
        
         wifiManager.addParameter(&custom_text4);
        wifiManager.addParameter(&custom_UTC_Timezone);
        wifiManager.addParameter(&custom_text5);
        wifiManager.addParameter(&custom_Time_S_W);
        wifiManager.addParameter(&custom_text3);
        wifiManager.addParameter(&custom_GPS_NTP);
        wifiManager.addParameter(&custom_text2);
        wifiManager.addParameter(&custom_mqtt_on);
        wifiManager.addParameter(&custom_mqtt_server);
        wifiManager.addParameter(&custom_mqtt_port);
        wifiManager.addParameter(&custom_mqtt_user);
        wifiManager.addParameter(&custom_mqtt_pass);
        wifiManager.addParameter(&custom_mqtt_root_topic);
        wifiManager.addParameter(&custom_mqtt_root_topic1);
        wifiManager.addParameter(&custom_mqtt_root_topic2);
        wifiManager.addParameter(&custom_mqtt_root_topic3);
        wifiManager.addParameter(&custom_mqtt_root_topic4);
        wifiManager.addParameter(&custom_mqtt_root_topic5);
         wifiManager.addParameter(&custom_mqtt_api_key);
         wifiManager.addParameter(&custom_web_pass);
        
        //Feste ip
        //wifiManager.setSTAStaticIPConfig(IPAddress(10,0,1,99), IPAddress(10,0,1,1), IPAddress(255,255,255,0));
        //wifiManager.setTimeout(120);
      
        if (!wifiManager.autoConnect("APConnect")) {
          Serial.println("failed to connect and hit timeout");
          delay(3000);
          ESP.reset();
          delay(5000);
        }
        Serial.println("wifiManager connected");
      
        strcpy(UTC_Timezone, custom_UTC_Timezone.getValue());
        strcpy(Time_S_W, custom_Time_S_W.getValue());
        strcpy(GPS_NTP, custom_GPS_NTP.getValue());
        strcpy(mqtt_on, custom_mqtt_on.getValue());
        strcpy(mqtt_server, custom_mqtt_server.getValue());
        strcpy(mqtt_port, custom_mqtt_port.getValue());
        strcpy(mqtt_user, custom_mqtt_user.getValue());
        strcpy(mqtt_pass, custom_mqtt_pass.getValue());
        strcpy(mqtt_root_topic, custom_mqtt_root_topic.getValue());
        strcpy(mqtt_root_topic1, custom_mqtt_root_topic1.getValue());
        strcpy(mqtt_root_topic2, custom_mqtt_root_topic2.getValue());
        strcpy(mqtt_root_topic3, custom_mqtt_root_topic3.getValue());
        strcpy(mqtt_root_topic4, custom_mqtt_root_topic4.getValue());
        strcpy(mqtt_root_topic5, custom_mqtt_root_topic5.getValue());
        strcpy(mqtt_api_key, custom_mqtt_api_key.getValue());
        strcpy(web_pass, custom_web_pass.getValue());
        
        if (shouldSaveConfig) {
          Serial.println("saving config");
          DynamicJsonBuffer jsonBuffer;
          JsonObject& json = jsonBuffer.createObject();
          
          json["UTC_Timezone"] = UTC_Timezone;
          json["Time_S_W"] = Time_S_W;
          json["GPS_NTP"] = GPS_NTP;
          json["mqtt_on"] = mqtt_on;
          json["mqtt_server"] = mqtt_server;
          json["mqtt_port"] = mqtt_port;
          json["mqtt_user"] = mqtt_user;
          json["mqtt_pass"] = mqtt_pass;
          json["mqtt_root_topic"] = mqtt_root_topic;
          json["mqtt_root_topic1"] = mqtt_root_topic1;
          json["mqtt_root_topic2"] = mqtt_root_topic2;
          json["mqtt_root_topic3"] = mqtt_root_topic3;
          json["mqtt_root_topic4"] = mqtt_root_topic4;
          json["mqtt_root_topic5"] = mqtt_root_topic5;
          json["mqtt_api_key"] = mqtt_api_key;
          json["web_pass"] = web_pass;
          
          File configFile = SPIFFS.open("/config.json", "w");
          if (!configFile) {
            Serial.println("failed to open config file for writing");
          }
      
          json.printTo(Serial);
          Serial.println(configFile);
          json.printTo(configFile);
          configFile.close();
        }

} 
