/*
 WiFi Web Server Roomba start
 A simple web server that lets start you a iRobot Roomba via the web.
 This sketch will print the IP address of your WiFi Shield (once connected)
 to the Serial monitor. From there, you can open that address in a web browser
 to start cleaning or dock the roomba.
 If the IP address of your shield is yourAddress:
 http://yourAddress/H sends Cleaning command
 http://yourAddress/L sends Dock command
 http://yourAddress/S sends Spot command
 http://yourAddress/SM sends Safe mode command
 http://yourAddress/P sends Power command
 http://yourAddress/C sends Controll command
 http://yourAddress/ST sends STOP command 
 
 This example was equipped with the WifiManager and an OTA update
  required hardware for the circuit:

 * ESP32 Wemos D1
 * Roomba wakeup pin attached to pin 0
 * Roomba RXD pin attached to pin 5
 * Roomba TXD pin attached to pin 4
 
 created for arduino 
ported for esp32 devboard V1
17.02.2019 by www.rohrhofer.org

The basic code was completely moved to the V2 version but is based on the V1 version from www.rohrhofer.org.
Mqtt and a Wifi Manager were added, an OTA update is also not possible.
The web interface was given with a password example: admin:admin encrypt with base 64 and enter (https://emn178.github.io/online-tools/base64_encode.html).

New Created for arduino
ported for esp32 Wemos D1 
07.11.2020 by www.wuckel.de

 
 */
#include <ArduinoOTA.h>
#include <SoftwareSerial.h>
#include <ArduinoJson.h>
#include <ESP8266WiFi.h>
#include <PubSubClient.h>
#include <TimeLib.h>
#include <WiFiUdp.h>
#include <Wire.h>
#include <DNSServer.h>
#include <ESP8266WebServer.h>
#include <WiFiManager.h>
#include <FS.h>
#include <WebOTA.h>

#include <pitches.h>

bool shouldSaveConfig = false;
bool saveConfig = false;

int zaehler=0;    //MQTT Wiederhohlung abbrechen Reconect vor Löschen Daten  
int count = 30;  //MQTT wiederhohlung senden Pause
unsigned long prevMillis;

// Update these with values suitable for your network.
char mqtt_server[16]  =    "";
char mqtt_port[6]      =   "1883";
char mqtt_user[20]     =   "";
char mqtt_pass[20]      =   "";
char mqtt_on[2]      =   "0"; //MQTT on=1 OFF=0
char mqtt_root_topic[40]  =  "stat/Roomba/RESULT";
char mqtt_root_topic1[40]  =  "tele/Roomba/STATE";
char mqtt_root_topic2[40]  =  "stat/Roomba/#";
char mqtt_root_topic3[40]  =  "tele/Roomba/#";
char mqtt_root_topic4[40]  =  "tele/Roomba/";
char mqtt_root_topic5[40]  =  "stat/Roomba/POWER";
char mqtt_api_key[40]  =  "80594f339bbaff6afb045334f1fa54fg";
char web_pass[20]      =   "YWRtaW46YWRtaW4="; //admin:admin beispiel base64 code
char GPS_NTP[2]      =   "1";
char UTC_Timezone[2]      =   "1";
char Time_S_W[2]      =   "0";

/**************************** FOR OTA **************************************************/
int OTAport = 8080;

//esp
WiFiClient espClient;
PubSubClient client(espClient);

// Wir setzen den Webserver auf Port 80
WiFiServer server(80);

void saveConfigCallback () {
  Serial.println("Should save config");
  shouldSaveConfig = true;
}

//#define LED LED_BUILTIN
#define LED D4      // on various NODEMCU boards the LED Pin is different.....

int RX_PIN = 5;
int TX_PIN = 4;
int PINwake = 0;

String ModeState = "OFF";
String ModeState_ID = "0";
String ModeState1 = "OFF";
String ModeState_ID1 = "0";
String ModeState2 = "OFF";
String ModeState_ID2 = "0";
String ModeState3 = "OFF";
String ModeState_ID3 = "0";
String ModeState4 = "OFF";
String ModeState_ID4 = "0";
String ModeState5 = "OFF";
String ModeState_ID5 = "0";

uint8_t id;

String header;

// NTP Servers:
IPAddress timeServer(217, 14, 146, 53);
const char* ntpServerName = "1.de.pool.ntp.org";
const int timeZone = 1;
String  newtime = "";
WiFiUDP Udp;
unsigned int localPort = 8888;  // local port to listen for UDP packets
const unsigned long INTERVAL = 1000L*60*1440; // 24 Stunden 1000L*60* 1440 Zeit synchronisieren
unsigned long lastRun = 0 - INTERVAL;  // damit es gleich beim Start losgeht

// Variables to save date and time
String formattedDate;
String dayStamp;
String timeStamp;

SoftwareSerial Roomba(RX_PIN, TX_PIN);


             void wakeUp (void){
              digitalWrite(PINwake, HIGH);
              delay(100);
              digitalWrite(PINwake, LOW);
              delay(500);
              digitalWrite(PINwake, HIGH);
              delay(2000);
            }
            



void setup()
{
    Serial.begin(115200);    
    Roomba.begin(115200);   
    pinMode(LED, OUTPUT);
    pinMode(PINwake, OUTPUT);      // set the LED pin mode   
    delay(10);


    // We start by connecting to a WiFi network
    digitalWrite(LED, HIGH); // Turn off LED Light
    Manger_Wifi_load();
    Serial.println("local ip");
    Serial.println(WiFi.localIP());    
    server.begin();
    Udp.begin(localPort); 
    Serial.println(Udp.localPort());
    Serial.println(ntpServerName);
    WiFi.hostByName(ntpServerName, timeServer);
    Serial.println("waiting for sync");
    setSyncProvider(getNtpTime);
    setSyncInterval(6000);    
    
    client.setServer(mqtt_server, 1883);
    client.setCallback(callback);        
              
}

int value = 0;

void loop(){

  String mqtt_on_off = mqtt_on;
  String GPS_NTP1 = GPS_NTP;

  if(GPS_NTP1 == "1"){
   if ( millis() - lastRun >= INTERVAL )
   {
     setDayTime(weekday()-1, hour(), minute());
     Serial.println("Set Time" + String(weekday()-1) + "-" + String(hour()) + "-" + String(minute()));
     lastRun += INTERVAL;
   }
  }  
  
  if(mqtt_on_off == "1"){
  if (!client.connected()) {
   reconnect();
  }
  client.loop();
  callmqttserver();
  }
  
  webota.handle();  
    
  Html_web(ModeState,ModeState_ID); 


}
